 ; Ŀ
 ;   Attar - create (array) and rename attributes at the same time.        
 ;   This version of Attar can be changed to increment the column letter   
 ;   by more than 1 by changing the value on line 173.                     
 ;   Copyright 1996, 2004, 2006 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Alph - increment a character string.                       
 ;   Takes one argument, a string.  Returns the incremented version.       
 ; 
 (DEFUN ALPH (cname / pos char base cnamp)
  (setq cname (strcase cname))
  (setq pos (strlen cname))
  (while (and (>= pos 1)
              (setq char (substr cname pos 1))
              (<= 90 (ascii char)))
         (setq pos (1- pos)))
 ; Ŀ
 ;   If no non-z characters were found, set all to A and add an A to the   
 ;   left end of the string.                                               
 ; 
  (cond ((= pos 0)
         (setq base "")
         (repeat (1+ (strlen cname))
                 (setq base (strcat base "A")))
         (setq cname base))
 ; Ŀ
 ;   If a non-Z was found, everything to the right of it becomes an A,     
 ;   and it is incremented.                                                
 ; 
        (T (setq cnamp cname)
           (setq cname (strcat (substr cname 1 (1- pos))
                               (chr (1+ (ascii (substr cname pos 1))))))
           (setq base "")
           (repeat (strlen (substr cnamp (1+ pos)))
                   (setq base (strcat base "A")))
           (setq cname (strcat cname base))))
 cname)
 ; Ŀ
 ;   Subroutine Alph end.                                                  
 ; 

 ; Ŀ
 ;   Subroutin Bliz - place a flake marker.                                
 ; 
 (DEFUN BLIZ (cen len colo ang / ang end pa pb pc pa1 pb1 pc1)
  (repeat 6
          (setq ang (+ ang (/ pi 3)))
          (setq end (polar cen (+ ang (/ pi 2)) (* len 0.5)))
          (setq pa (polar cen (+ ang (* pi (/ 2 3.0))) (* len 0.242873)))
          (setq pb (polar cen (+ ang (/ pi 2)) (* len 0.096394)))
          (setq pc (polar cen (+ ang (/ pi 3)) (* len 0.242873)))
          (setq pa1 (polar cen (+ ang (* (/ 106.63 180) pi)) (* len 0.433656)))
          (setq pb1 (polar cen (+ ang (/ pi 2)) (* len 0.299070)))
          (setq pc1 (polar cen (+ ang (* (/ 73.3699 180) pi))
                                      (* len 0.433656)))
          (grdraw cen end colo)
          (grdraw pa pb colo)
          (grdraw pb pc colo)
          (grdraw pa1 pb1 colo)
          (grdraw pb1 pc1 colo))
 (princ))
 ; Ŀ
 ;   Bliz end.                                                             
 ; 

 ; Ŀ
 ;   Attar.                                                                
 ; 
 (DEFUN C:ATTAR (/ aa aap enampt enam entt rad rowsp colsp rowdsp coldsp charc
                                          len basnum1 gnutag entt num basnum)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Find the last entity in the drawing.                                  
 ; 
  (setq aa (entlast))
  (while (setq aap (entnext aa))
         (setq aa aap))
 ; Ŀ
 ;   Prompt for a single attdef.                                           
 ; 
  (cond ((null (setq enampt (entsel "Select Attdef to array: ")))
         (prompt "\nNothing selected.")
         (exit))
        ((not (and (setq enam (car enampt))
                   (setq entt (entget enam))
                   (= "ATTDEF" (cdr (assoc 0 (entget enam))))))
         (prompt "\nThat wasn't an attdef.")
         (exit))
        (t
         (setq rad (/ (getvar "viewsize") 12))
         (bliz (setq pa (cdr (assoc 10 entt))) rad -1 (/ pi 12))))
 ; Ŀ
 ;   Get the dimensions of the array.                                      
 ;   First make sure the global variables contain appropriate values.      
 ; 
  (if (/= (type rows) 'INT) (setq rows 1))
  (if (/= (type cols) 'INT) (setq cols 1))
  (if (/= (type rowdis) 'REAL) (setq rowdis 1.0))
  (if (/= (type coldis) 'REAL) (setq coldis 1.0))
 ; Ŀ
 ;   Row number and spacing.                                               
 ; 
  (if (setq rowsp (getint (strcat "\nNumber of rows --- <" (itoa rows) ">: ")))
      (setq rows rowsp))
  (if (> rows 1)
      (progn
           (if (setq rowdsp (getdist (strcat "\nDistance between crows <"
                                              (rtos rowdis 2 2) ">: ")))
               (setq rowdis (- rowdsp)))))
 ; Ŀ
 ;   Column number and spacing.                                            
 ; 
  (if (setq colsp (getint (strcat "\nNumber of columns ||| <"
                                  (itoa cols) ">: ")))
      (setq cols colsp))
  (if (> cols 1)
      (progn
           (if (setq coldsp (getdist (strcat "\nDistance between columns <"
                                              (rtos coldis 2 2) ">: ")))
               (setq coldis coldsp))))
 ; Ŀ
 ;   Get the starting number and character for the attributes.             
 ; 
  (setq charc (strcase (getstring "\nFirst Column letter: ")))
  (setq basnum1 (getint "\nFirst Row number: "))
 ; Ŀ
 ;   Make the array.                                                       
 ; 
  (cond ((and (> rows 1) (> cols 1))
         (command "array" enam "" "R" rows cols rowdis coldis))
        ((> rows 1)
         (command "array" enam "" "R" rows cols rowdis))
        ((> cols 1)
         (command "array" enam "" "R" rows cols coldis)))
 ; Ŀ
 ;   Now step through the new entities and retag and prompt them.          
 ;   First do the entity saved as Enam, which isn't necessarily the last   
 ;   entity in the drawing - this is saved in AA.                          
 ; 
  (setq basnum basnum1)
  (setq gnutag (strcat charc (itoa basnum)))
  (setq entt (entget enam))
  (setq entt (subst (cons 1 "") (assoc 1 entt) entt))
  (setq entt (subst (cons 3 gnutag) (assoc 3 entt) entt))
  (entmod (subst (cons 2 gnutag) (assoc 2 entt) entt))
 ; Ŀ
 ;   Now step through the new entities and retag and prompt them.          
 ; 
  (setq num 1)
  (while (if aa
             (progn
                  (setq enam (entnext aa))
                  (setq aa ())
                  T)
             (setq enam (entnext enam)))
         (setq num (1+ num))
 ; Ŀ
 ;   Make the new tag name string.                                         
 ; 
         (if (> num rows)
             (progn
                  (setq num 1)
                  (setq basnum basnum1)
 ; Ŀ
 ;   Changing the number of repeats in the next line can increment the     
 ;   attribute/cell character by more then one, which is handy for use     
 ;   with spreadsheets having merged cells or drawings where cells are     
 ;   skipped in a repeating pattern.                                       
 ; 
                  (repeat 1 (setq charc (alph charc))))
             (setq basnum (1+ basnum)))
         (setq gnutag (strcat charc (itoa basnum)))
 ; Ŀ
 ;   Modify the attribute.                                                 
 ; 
         (setq entt (entget enam))
         (setq entt (subst (cons 1 "") (assoc 1 entt) entt))
         (setq entt (subst (cons 3 gnutag) (assoc 3 entt) entt))
         (entmod (subst (cons 2 gnutag) (assoc 2 entt) entt)))
 ; Ŀ
 ;   Remove the snowflake.                                                 
 ; 
  (bliz pa rad -1 (/ pi 12))
 (princ))